/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.networking;

import java.util.Locale;
import net.impactdev.impactor.api.configuration.Config;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.core.economy.EconomyConfig;
import net.impactdev.impactor.core.economy.ImpactorEconomyService;
import net.impactdev.impactor.core.economy.accounts.AccountManager;
import net.impactdev.impactor.core.economy.networking.EconomyNetworkingService;
import net.impactdev.impactor.core.economy.networking.messenger.redis.RedisConfig;
import net.impactdev.impactor.core.economy.networking.messenger.redis.RedisProvider;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;

public final class NetworkingFactory {
    private final BaseImpactorPlugin plugin;
    private final ImpactorEconomyService service;

    public NetworkingFactory(BaseImpactorPlugin plugin, ImpactorEconomyService service) {
        this.plugin = plugin;
        this.service = service;
    }

    public EconomyNetworkingService create(AccountManager manager) {
        RedisConfig redis;
        PluginLogger logger = this.plugin.logger();
        Config config = this.service.config();
        String request = config.get(EconomyConfig.MESSAGING_SERVICE);
        if (request.equals("none")) {
            request = "auto";
        }
        if (request.equals("auto") && (redis = config.get(EconomyConfig.REDIS)).enabled()) {
            request = "redis";
        }
        if (request.equals("auto")) {
            this.plugin.logger().warn("Couldn't find a suitable networking setup, no networking will be performed...");
            return null;
        }
        logger.info("Loading messaging service... [" + request.toUpperCase(Locale.ROOT) + "]");
        EconomyNetworkingService service = this.createByRequest(request, manager);
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("Couldn't find a suitable networking setup");
    }

    private EconomyNetworkingService createByRequest(String request, AccountManager manager) {
        if (request.equals("redis")) {
            RedisConfig redis = this.service.config().get(EconomyConfig.REDIS);
            if (redis.enabled()) {
                try {
                    return new EconomyNetworkingService(this.plugin, manager, new RedisProvider(this.plugin.logger(), redis));
                }
                catch (Exception e) {
                    this.plugin.logger().severe("Encountered an exception while enabling Redis messaging service...", e);
                }
            } else {
                this.plugin.logger().warn("Messaging service was set to redis, but redis is disabled...");
            }
        }
        return null;
    }
}

